import { View, Text, TouchableOpacity } from 'react-native';
import React from 'react';
import { filtersStyles } from './filtersStyle';
import CustomCheckbox from '../../Utilities/CustomCheckbox/CustomCheckbox';

const SelectBrand = ({ brands, handleSelectItem, itemTitle }) => {
    return (
        <View style={filtersStyles.selectBrandContainer}>
            {brands.map((item, index) => (
                <TouchableOpacity
                    key={`key${index}`}
                    style={filtersStyles.selececolorCont1}
                    onPress={() => {
                        handleSelectItem(itemTitle, item, index);
                    }}
                >
                    <CustomCheckbox
                        handleSelectItem={handleSelectItem}
                        index={index}
                        item={item}
                        itemTitle={itemTitle}
                        checked={item.isChecked}
                    />
                    <Text
                        style={filtersStyles.colorText(item.isChecked)}
                    >
                        {item?.value || item?.name}
                    </Text>
                </TouchableOpacity>
            ))}
        </View>
    );
};

export default SelectBrand;
